% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csdm_specs.R
\name{csdm_lr}
\alias{csdm_lr}
\title{Specification: Long-run configuration}
\usage{
csdm_lr(
  vars = NULL,
  type = c("none", "ecm", "ardl", "csdl"),
  ylags = 0,
  xdlags = 0,
  options = list()
)
}
\arguments{
\item{vars}{Reserved for future use.}

\item{type}{One of c("none","ecm","ardl","csdl").}

\item{ylags}{Integer >= 0. Within-unit lags of the dependent variable to include
when supported by the chosen model/type.}

\item{xdlags}{Integer >= 0. Scalar distributed lags to apply to each RHS regressor
when supported by the chosen model/type.}

\item{options}{Reserved for future use.}
}
\value{
A spec object (list) used by csdm().
}
\description{
Specification: Long-run configuration
}
\examples{
# Long-run / dynamic configuration (ARDL-style lags)
lr <- csdm_lr(type = "ardl", ylags = 1)
lr

# Minimal end-to-end DCCE example (kept small for speed)
data(PWT_60_07, package = "csdm")
df <- PWT_60_07
keep_ids <- unique(df$id)[1:10]
df_small <- df[df$id \%in\% keep_ids & df$year >= 1970, ]
fit <- csdm(
  log_rgdpo ~ log_hc + log_ck + log_ngd,
  data = df_small,
  id = "id",
  time = "year",
  model = "dcce",
  csa = csdm_csa(vars = c("log_rgdpo", "log_hc", "log_ck", "log_ngd"), lags = 3),
  lr = csdm_lr(type = "ardl", ylags = 1)
)
summary(fit)
}
