\name{wast_screening_tool}
\alias{wast_screening_tool}
\title{
Woman Abuse Screening Tool (WAST)
}
\description{
Calculates the results of the Woman Abuse Screening Tool (WAST), used to identify intimate partner violence (IPV). The tool begins with two general questions (WAST-Short). If positive, further specific questions regarding physical and sexual abuse are asked.
}
\usage{
wast_screening_tool(tension_level, argument_difficulty, partner_abuse_history,
                    partner_frightening, hit_kicked_punched, physical_abuse_outside,
                    sexual_abuse_outside, sexual_abuse_current_partner)
}
\arguments{
  \item{tension_level}{
Numeric (0-2). "In general, how would you describe your relationship?"
0: No tension
1: Some tension
2: A lot of tension
}
  \item{argument_difficulty}{
Numeric (0-2). "Do you and your partner work out arguments with..."
0: No difficulty
1: Some difficulty
2: Great difficulty
}
  \item{partner_abuse_history}{
Numeric (0 or 1). Do arguments ever result in you feeling down or bad about yourself? (Or similar emotional abuse query depending on version). (1 = Yes).
}
  \item{partner_frightening}{
Numeric (0 or 1). Do arguments ever result in hitting, kicking, or pushing? (1 = Yes).
}
  \item{hit_kicked_punched}{
Numeric (0 or 1). Do you ever feel frightened by what your partner says or does? (1 = Yes).
}
  \item{physical_abuse_outside}{
Numeric (0 or 1). Has your partner ever abused you physically? (1 = Yes).
}
  \item{sexual_abuse_outside}{
Numeric (0 or 1). Has your partner ever abused you sexually? (1 = Yes).
}
  \item{sexual_abuse_current_partner}{
Numeric (0 or 1). (Additional items may vary by implementation, typically standard 8 questions). (1 = Yes).
}
}
\value{
A list containing:
\item{WAST_Short_Result}{Interpretation of the first two screening questions.}
\item{WAST_Total_Items_Positive}{Count of positive responses across the full tool.}
\item{Recommendation}{Suggested next steps.}
}
\references{
Brown JB, Lent B, Brett PJ, Sas G, Pederson LL. Development of the Woman Abuse Screening Tool for use in family practice. Fam Med. 1996;28(6):422-428.
}
\examples{

# Example 1: Positive Short Screen
# Tension (2), Difficulty (2)
wast_screening_tool(2, 2, 0, 0, 0, 0, 0, 0)

# Example 2: Negative Short Screen
# No tension (0), No difficulty (0)
wast_screening_tool(0, 0, 0, 0, 0, 0, 0, 0)
}
