\name{new_orleans_head_ct_rule}
\alias{new_orleans_head_ct_rule}
\title{
New Orleans Charity Head Trauma/Injury Rule
}
\description{
Calculates the New Orleans Charity Head Trauma Rule result. This clinical decision rule identifies patients with minor head injury (GCS 15) who require a CT scan to rule out intracranial injury. If any one of the seven criteria is present, a CT is indicated.
}
\usage{
new_orleans_head_ct_rule(headache, vomiting, age_gt_60, intoxication,
                         anterograde_amnesia, trauma_above_clavicles, seizure)
}
\arguments{
  \item{headache}{
Numeric (0 or 1). Is headache present? (1 = Yes).
}
  \item{vomiting}{
Numeric (0 or 1). Is vomiting present? (1 = Yes).
}
  \item{age_gt_60}{
Numeric (0 or 1). Is the patient older than 60 years? (1 = Yes).
}
  \item{intoxication}{
Numeric (0 or 1). Is there drug or alcohol intoxication? (1 = Yes).
}
  \item{anterograde_amnesia}{
Numeric (0 or 1). Is there persistent anterograde amnesia (short-term memory deficits)? (1 = Yes).
}
  \item{trauma_above_clavicles}{
Numeric (0 or 1). Is there visible trauma above the clavicles? (1 = Yes).
}
  \item{seizure}{
Numeric (0 or 1). Did a seizure occur? (1 = Yes).
}
}
\value{
A list containing:
\item{Recommendation}{Guidance on whether a CT scan is indicated.}
\item{Criteria_Met_Count}{The number of positive criteria found.}
}
\references{
Haydel MJ, Preston CA, Mills TJ, Luber S, Blaudeau E, DeBlieux PM. Indications for computed tomography in patients with minor head injury. N Engl J Med. 2000;343(2):100-105. doi:10.1056/NEJM200007133430204
}
\examples{

# Example 1: CT Indicated
# Headache (1), no other signs
new_orleans_head_ct_rule(1, 0, 0, 0, 0, 0, 0)

# Example 2: CT Not Indicated
# No criteria met
new_orleans_head_ct_rule(0, 0, 0, 0, 0, 0, 0)
}
