\name{lille_model_score}
\alias{lille_model_score}
\title{
Lille Model for Alcoholic Hepatitis
}
\description{
Calculates the Lille Model score to predict 6-month mortality in patients with severe alcoholic hepatitis treated with steroids. It is used at Day 7 of treatment to determine whether the patient is a "responder" or "non-responder," helping guide the decision to continue or stop corticosteroids.
}
\usage{
lille_model_score(age, renal_insufficiency, albumin, bilirubin_day0,
                  bilirubin_day7, pt_seconds, bilirubin_units = "mg/dL",
                  albumin_units = "g/dL")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{renal_insufficiency}{
Numeric (0 or 1). Creatinine > 1.3 mg/dL (> 115 µmol/L) or CrCl < 40 mL/min. (1 = Yes).
}
  \item{albumin}{
Numeric. Serum albumin level.
}
  \item{bilirubin_day0}{
Numeric. Total bilirubin on Day 0 (start of treatment).
}
  \item{bilirubin_day7}{
Numeric. Total bilirubin on Day 7 of treatment.
}
  \item{pt_seconds}{
Numeric. Prothrombin Time in seconds.
}
  \item{bilirubin_units}{
String. Units for bilirubin. "mg/dL" (default) or "umol/L".
}
  \item{albumin_units}{
String. Units for albumin. "g/dL" (default) or "g/L".
}
}
\value{
A list containing:
\item{Lille_Model_Score}{The calculated probability score (0-1).}
\item{Interpretation}{Clinical guidance (Responder < 0.45, Non-responder >= 0.45).}
}
\references{
Louvet A, Naveau S, Abdelnour M, et al. The Lille model: a new tool for therapeutic strategy in patients with severe alcoholic hepatitis treated with steroids. Hepatology. 2007;45(6):1348-1354. doi:10.1002/hep.21607
}
\examples{

# Example 1: Responder
# Age 45, No Renal, Alb 3.5 g/dL, Bili 10->5 mg/dL, PT 15s
lille_model_score(45, 0, 3.5, 10, 5, 15)

# Example 2: Non-Responder
# Age 55, Renal Yes, Alb 2.5 g/dL, Bili 15->14 mg/dL, PT 25s
lille_model_score(55, 1, 2.5, 15, 14, 25)
}
