\name{hemorr2hages_score}
\alias{hemorr2hages_score}
\title{
HEMORR2HAGES Score for Major Bleeding Risk
}
\description{
Calculates the HEMORR2HAGES score to estimate the risk of major bleeding in elderly patients with atrial fibrillation who are taking warfarin. This score is considered more sensitive than CHADS2 for identifying bleeding risk in this specific population.
}
\usage{
hemorr2hages_score(hepatic_renal_disease, ethanol_abuse, malignancy, age_gt_75,
                   reduced_platelets_function, prior_bleed, hypertension, anemia,
                   genetic_factors, fall_risk, stroke_history)
}
\arguments{
  \item{hepatic_renal_disease}{
Numeric (0 or 1). Hepatic or Renal Disease. (1 = Yes, +1 point).
}
  \item{ethanol_abuse}{
Numeric (0 or 1). Ethanol (Alcohol) Abuse. (1 = Yes, +1 point).
}
  \item{malignancy}{
Numeric (0 or 1). History of Malignancy. (1 = Yes, +1 point).
}
  \item{age_gt_75}{
Numeric (0 or 1). Age > 75 years. (1 = Yes, +1 point).
}
  \item{reduced_platelets_function}{
Numeric (0 or 1). Reduced platelet count or function (e.g., Aspirin use). (1 = Yes, +1 point).
}
  \item{prior_bleed}{
Numeric (0 or 1). History of prior bleeding (Re-bleeding risk). (1 = Yes, +2 points).
}
  \item{hypertension}{
Numeric (0 or 1). Uncontrolled Hypertension. (1 = Yes, +1 point).
}
  \item{anemia}{
Numeric (0 or 1). Anemia. (1 = Yes, +1 point).
}
  \item{genetic_factors}{
Numeric (0 or 1). Genetic factors (e.g., CYP2C9 polymorphisms). (1 = Yes, +1 point).
}
  \item{fall_risk}{
Numeric (0 or 1). Excessive Fall Risk. (1 = Yes, +1 point).
}
  \item{stroke_history}{
Numeric (0 or 1). History of Stroke. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{HEMORR2HAGES_Score}{The calculated score (Range 0-12).}
\item{Risk_Category}{Classification (Low, Intermediate, High).}
\item{Bleeding_Risk_per_100_Pt_Years}{Estimated number of major bleeds per 100 patient-years.}
}
\references{
Gage BF, Yan Y, Milligan PE, et al. Clinical classification schemes for predicting hemorrhage: results from the National Registry of Atrial Fibrillation (NRAF). Am Heart J. 2006;151(3):713-719. doi:10.1016/j.ahj.2005.04.017
}
\examples{

# Example 1: High Risk
# Prior Bleed (+2), Age >75 (+1), HTN (+1)
# Score = 4
hemorr2hages_score(0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0)

# Example 2: Low Risk
# No risk factors
# Score = 0
hemorr2hages_score(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
}
