\name{gps_cancer_score}
\alias{gps_cancer_score}
\title{
Glasgow Prognostic Score (GPS) for Cancer Outcomes
}
\description{
Calculates the Glasgow Prognostic Score (GPS) to predict survival outcomes in patients with advanced cancer. This score uses C-Reactive Protein (CRP) and Albumin levels to reflect the systemic inflammatory response and nutritional status, which are strong independent prognostic factors in various malignancies.
}
\usage{
gps_cancer_score(crp_mg_l, albumin_g_l)
}
\arguments{
  \item{crp_mg_l}{
Numeric. Serum C-Reactive Protein level in mg/L. (> 10 mg/L indicates elevated inflammation).
}
  \item{albumin_g_l}{
Numeric. Serum Albumin level in g/L. (< 35 g/L indicates hypoalbuminemia).
}
}
\value{
A list containing:
\item{GPS_Score}{The calculated score (0, 1, or 2).}
\item{Prognosis}{Risk classification (Good, Intermediate, Poor).}
}
\references{
Forrest LM, McMillan DC, McArdle CS, et al. Evaluation of cumulative prognostic scores based on the systemic inflammatory response in patients with inoperable non-small-cell lung cancer. Br J Cancer. 2003;89(6):1028-1030. doi:10.1038/sj.bjc.6601242
}
\examples{

# Example 1: Poor Prognosis
# CRP 20 (>10), Albumin 30 (<35)
# Score = 2
gps_cancer_score(20, 30)

# Example 2: Good Prognosis
# CRP 5 (<10), Albumin 40 (>35)
# Score = 0
gps_cancer_score(5, 40)
}
