\name{cp_aki_risk_score}
\alias{cp_aki_risk_score}
\title{
CP-AKI Risk Calculator
}
\description{
Calculates the Cisplatin-Associated Acute Kidney Injury (CP-AKI) Risk Score. This tool estimates the probability of developing acute kidney injury in patients undergoing treatment with intravenous cisplatin. The score incorporates patient demographics, vital signs, and laboratory values to stratify risk.
}
\usage{
cp_aki_risk_score(age_ge_61, systolic_bp_gt_140, low_hemoglobin, low_albumin,
                  low_potassium, low_calcium, low_magnesium, high_creatinine_dose,
                  high_cisplatin_dose)
}
\arguments{
  \item{age_ge_61}{
Numeric (0 or 1). Age >= 61 years. (1 = Yes, +1.5 points).
}
  \item{systolic_bp_gt_140}{
Numeric (0 or 1). Systolic Blood Pressure > 140 mmHg. (1 = Yes, +1.5 points).
}
  \item{low_hemoglobin}{
Numeric (0 or 1). Hemoglobin (Male <= 13.4 g/dL; Female <= 12.4 g/dL). (1 = Yes, +1.0 point).
}
  \item{low_albumin}{
Numeric (0 or 1). Serum Albumin <= 3.9 g/dL. (1 = Yes, +2.5 points).
}
  \item{low_potassium}{
Numeric (0 or 1). Serum Potassium <= 4.0 mmol/L. (1 = Yes, +2.0 points).
}
  \item{low_calcium}{
Numeric (0 or 1). Serum Calcium <= 9.3 mg/dL. (1 = Yes, +1.5 points).
}
  \item{low_magnesium}{
Numeric (0 or 1). Serum Magnesium <= 1.8 mg/dL. (1 = Yes, +1.5 points).
}
  \item{high_creatinine_dose}{
Numeric (0 or 1). Dose of Cisplatin per Serum Creatinine level >= 60 mg/mg. (1 = Yes, +1.5 points).
}
  \item{high_cisplatin_dose}{
Numeric (0 or 1). Dose of Cisplatin >= 50 mg. (1 = Yes, +2.5 points).
}
}
\value{
A list containing:
\item{CP_AKI_Score}{The calculated risk score (Range 0-15.5).}
\item{Risk_Group}{Risk classification (Low, Moderate, High).}
\item{Est_Risk_AKI}{Estimated probability of developing AKI.}
}
\references{
Motwani SS, et al. Development and Validation of a Risk Prediction Model for Acute Kidney Injury After the First Course of Cisplatin. J Clin Oncol. 2018.
}
\examples{

# Example 1: High Risk
# Age 65 (+1.5), SBP 150 (+1.5), Low Alb (+2.5), High Cisplatin (+2.5)
# Score = 8.0
cp_aki_risk_score(1, 1, 0, 1, 0, 0, 0, 0, 1)

# Example 2: Low Risk
# Age 40 (0), Normal labs, Low Cisplatin Dose
# Score = 0
cp_aki_risk_score(0, 0, 0, 0, 0, 0, 0, 0, 0)
}
