% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_methods.R
\name{pair_spearman}
\alias{pair_spearman}
\title{Spearman correlation}
\usage{
pair_spearman(d, handle.na = TRUE, warnings = TRUE, ...)
}
\arguments{
\item{d}{A dataframe}

\item{handle.na}{If TRUE uses pairwise complete observations to calculate correlation coefficient, otherwise NAs not handled.}

\item{warnings}{If TRUE, generates a warning for datasets of one row, one column, or with constant variables.}

\item{...}{other arguments}
}
\value{
A tibble of class \code{pairwise} with calculated association value for every numeric variable pair,
or NULL if there are not at least two numeric variables
}
\description{
Calculates Spearman's correlation for every numeric variable pair in a dataset.
}
\examples{
pair_spearman(iris)
# same as
pair_cor(iris, method="spearman")
}
\seealso{
See \code{\link{pair_methods}}  for other score options.
}
