% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_upload_blob.R
\name{bs_upload_blob}
\alias{bs_upload_blob}
\title{Upload a blob to a repo}
\usage{
bs_upload_blob(
  blob,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{blob}{Character, files to upload to a repo.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of upload blob information
}
\description{
Upload a blob to a repo
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/uploadBlob.json}{repo/uploadBlob.json (2023-11-24)}
}

\section{Function introduced}{

\code{v0.1.0} (2023-11-24)
}

\examples{
\dontshow{if (has_bluesky_pass() & has_bluesky_user()) withAutoprint(\{ # examplesIf}
fig <- fs::path_package('bskyr', 'man/figures/logo.png')
bs_upload_blob(fig)
\dontshow{\}) # examplesIf}
}
\concept{repo}
