% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{userList}
\alias{userList}
\alias{userListItem}
\title{AdminLTE3 user list container}
\usage{
userList(...)

userListItem(image, title, subtitle = NULL)
}
\arguments{
\item{...}{slot for \link{userListItem}.}

\item{image}{image url or path.}

\item{title}{Item title.}

\item{subtitle}{Item subtitle.}
}
\description{
\link{userList} creates a user list container to be inserted in a \link{box}.

\link{userListItem} creates a user list item.
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)

 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      title = "User List example",
      status = "success",
      userList(
        userListItem(
          image = "https://adminlte.io/themes/v3/dist/img/user1-128x128.jpg",
          title = "Shiny",
          subtitle = "Package 1"
        ),
        userListItem(
          image = "https://adminlte.io/themes/v3/dist/img/user8-128x128.jpg",
          title = "Tidyverse",
          subtitle = "Package 2"
        ),
        userListItem(
          image = "https://adminlte.io/themes/v3/dist/img/user7-128x128.jpg",
          title = "tidyr",
          subtitle = "Package 3"
        )
      )
     )
    ),
    title = "User List"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
