% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniform_distribution.R
\name{uniform_distribution}
\alias{uniform_distribution}
\alias{uniform_pdf}
\alias{uniform_lpdf}
\alias{uniform_cdf}
\alias{uniform_lcdf}
\alias{uniform_quantile}
\title{Uniform Distribution Functions}
\usage{
uniform_distribution(lower = 0, upper = 1)

uniform_pdf(x, lower = 0, upper = 1)

uniform_lpdf(x, lower = 0, upper = 1)

uniform_cdf(x, lower = 0, upper = 1)

uniform_lcdf(x, lower = 0, upper = 1)

uniform_quantile(p, lower = 0, upper = 1)
}
\arguments{
\item{lower}{lower bound of the distribution (default is 0)}

\item{upper}{upper bound of the distribution (default is 1)}

\item{x}{quantile}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Uniform distribution.
}
\examples{
# Uniform distribution with lower = 0, upper = 1
dist <- uniform_distribution(0, 1)
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
mean(dist)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)
skewness(dist)
kurtosis(dist)
kurtosis_excess(dist)

# Convenience functions
uniform_pdf(0.5)
uniform_lpdf(0.5)
uniform_cdf(0.5)
uniform_lcdf(0.5)
uniform_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/uniform_dist.html}{Boost Documentation} for more details on the mathematical background.
}
