% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{zscore_train}
\alias{zscore_train}
\title{Z-score standardization using training period statistics}
\usage{
zscore_train(M, T_train, eps = 1e-08)
}
\arguments{
\item{M}{Numeric matrix of dimensions T x S (time by sectors)}

\item{T_train}{Integer. Number of observations in training period}

\item{eps}{Numeric. Minimum standard deviation threshold to avoid
division by zero. Default is 1e-8.}
}
\value{
A list with components:
  \describe{
    \item{Mz}{Standardized matrix of same dimensions as M}
    \item{mu}{Vector of training means for each column}
    \item{sd}{Vector of training standard deviations for each column}
  }
}
\description{
Standardizes a matrix using mean and standard deviation computed
from the training period only.
}
\examples{
M <- matrix(rnorm(100), nrow = 20, ncol = 5)
result <- zscore_train(M, T_train = 14)
str(result)

}
