% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_terms.R
\name{translate_terms}
\alias{translate_terms}
\title{Translate Terms from One Nomenclature to Another}
\usage{
translate_terms(
  input_terms,
  mapping_col = "PKNCA",
  target_col = "PPTESTCD",
  metadata = metadata_nca_parameters
)
}
\arguments{
\item{input_terms}{A character vector of terms to be translated.}

\item{mapping_col}{Character indicating the column name in the metadata file of the input terms.
Default is "PKNCA".}

\item{target_col}{Character indicating the column name in the metadata file of the target terms.
Default is "PPTESTCD".}

\item{metadata}{Dataset used to do the mapping that contains the mapping and target columns.}
}
\value{
A character vector of translated terms. Input terms not available in mapping_col will be
returned with the same value.
}
\description{
This function translates a character vector of terms from one nomenclature to another using a
mapping file.
}
\examples{
input_terms <- c("adj.r.squared", "ae", "nonexistent_term")
translate_terms(input_terms)
}
