% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_operators.R
\name{get_label}
\alias{get_label}
\title{Get the Label of a Heading}
\usage{
get_label(variable, type = "ADNCA", labels_df = metadata_nca_variables)
}
\arguments{
\item{variable}{The variable for which the label is to be retrieved.}

\item{type}{The type of the dataset for which the label is to be retrieved.}

\item{labels_df}{A data frame containing at least the columns "Variable", "Label", and "Dataset".}
}
\value{
The label of the heading if it exists in the labels file,
otherwise the variable name.
}
\description{
This function retrieves the label of a heading from a labels file.
}
\examples{
 LABELS <- data.frame(
   Variable = c("USUBJID", "AVAL"),
   Label = c("Unique Subject Identifier", "Analysis Value"),
   Dataset = c("ADNCA", "ADNCA")
 )
 get_label("USUBJID", "ADNCA", LABELS)  # Returns "Unique Subject Identifier"
 get_label("AGE", "ADNCA", LABELS)  # Returns "AGE"

}
