% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine_helper_f.R
\name{with_write_flags_lang}
\alias{with_write_flags_lang}
\title{Evaluate a language object with write-tracking via active bindings}
\usage{
with_write_flags_lang(expr_lang, tracked, env, flag_value = 1L)
}
\arguments{
\item{expr_lang}{A language object (call or expression) to evaluate.
For example, \code{react_list[[i]][["react"]]} returned by \code{add_reactevt()}.}

\item{tracked}{Character vector of \strong{top-level} variable names to track
(e.g., \code{c("q_default","c_default","curtime")}). For each name \code{nm},
an active binding is installed at \code{env[[nm]]}, and writes set
\code{env[[paste0(nm, "_lastupdate")]] <- flag_value}.}

\item{env}{Environment in which to install the bindings and evaluate
\code{expr_lang} (your per-patient/per-arm working environment).}

\item{flag_value}{Scalar written into each \verb{*_lastupdate} when a write
occurs (commonly \code{1L}; you may use a timestamp like \code{env$curtime}).}
}
\value{
Invisibly returns \code{NULL}. The function works by side effects
(mutating \code{env} and its \verb{*_lastupdate} flags).
}
\description{
Temporarily installs \strong{active bindings} for a set of variable names in
\code{env} so that any \strong{write} to those names during the evaluation of
\code{expr_lang} flips a corresponding \verb{*_lastupdate} flag in \code{env}.
This flags assignments even when the value is overwritten with the same
value, and does not flag branches that are not executed.
}
\details{
Typical use: when \code{accum_backwards = TRUE}, wrap the evaluation of a
reaction/input block so you can later accumulate only inputs that were
actually written in that event.
\itemize{
\item The function creates a private backing store for \code{tracked} names and
installs active bindings in \code{env}. Reads return the stored value.
Writes (via \verb{<-} or \code{=}) update the store \strong{and} set the corresponding
\verb{*_lastupdate} flag in \code{env}.
\item It \strong{does not} zero the \verb{*_lastupdate} flags; do that before calling
this function (typically once per event).
\item Only \strong{top-level symbols} are tracked. To track \code{obj$el <- ...}, track
\code{"obj"} (the container) rather than \code{"obj$el"}.
\item Active bindings are removed and plain symbols restored on exit, even if
an error occurs (via \code{on.exit()} teardown).
}
}
\section{Performance}{

Active bindings add a tiny overhead per read/write of the tracked names
(a function call). Keep \code{tracked} small and the binding body minimal.
Install only for the duration of the block and tear down immediately
(handled for you). If your block performs many reads and few writes,
consider a snapshot-and-diff approach instead
}

\keyword{internal}
