% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo.R
\name{TrivialTree}
\alias{TrivialTree}
\alias{SingleTaxonTree}
\alias{ZeroTaxonTree}
\title{Generate trivial trees}
\usage{
SingleTaxonTree(label = "t1", lengths = NULL)

ZeroTaxonTree()
}
\arguments{
\item{label}{a character vector specifying the label of the tip.}

\item{lengths}{a numeric vector specifying the edge lengths of the tree.}
}
\value{
\code{SingleTaxonTree()} returns a \code{phylo} object containing a single
tip with the specified label.

\code{ZeroTaxonTree()} returns an empty \code{phylo} object.
}
\description{
\code{SingleTaxonTree()} creates a phylogenetic "tree" that contains a single
taxon.
\code{ZeroTaxonTree()} creates an empty \code{phylo} object with zero leaves or edges.
}
\examples{
SingleTaxonTree("Homo_sapiens")
plot(SingleTaxonTree("root") + BalancedTree(4))

ZeroTaxonTree()
}
\seealso{
Other tree manipulation: 
\code{\link{AddTip}()},
\code{\link{CollapseNode}()},
\code{\link{ConsensusWithout}()},
\code{\link{DropTip}()},
\code{\link{ImposeConstraint}()},
\code{\link{KeptPaths}()},
\code{\link{KeptVerts}()},
\code{\link{LeafLabelInterchange}()},
\code{\link{MakeTreeBinary}()},
\code{\link{Renumber}()},
\code{\link{RenumberTips}()},
\code{\link{RenumberTree}()},
\code{\link{RootTree}()},
\code{\link{SortTree}()},
\code{\link{Subtree}()},
\code{\link{TipTimedTree}()}

Other tree generation functions: 
\code{\link{ConstrainedNJ}()},
\code{\link{GenerateTree}},
\code{\link{NJTree}()},
\code{\link{TreeNumber}}
}
\concept{tree generation functions}
\concept{tree manipulation}
\keyword{tree}
