% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{isDiscrete}
\alias{isDiscrete}
\title{Heuristic check for discrete numeric data}
\usage{
isDiscrete(
  x,
  tol = sqrt(.Machine$double.eps),
  unique_ratio = 0.2,
  max_levels = 10
)
}
\arguments{
\item{x}{Numeric vector.}

\item{tol}{Relative tolerance for "integer-like" checks.}

\item{unique_ratio}{Max ratio of unique values to n to still consider discrete (must be < 1).}

\item{max_levels}{Max absolute number of unique values to still consider discrete.}
}
\value{
TRUE/FALSE best-guess.
}
\description{
Assumes x is numeric, length(x) >= 4, and all values are finite and non-missing.
}
\details{
Uses integer-within-tolerance and low unique-to-n with repetition (via unique ratio).
}
