#' Get the value of a specified SEM path parameter after case deletion
#'
#' This helper function refits the specified SEM model after dropping
#' the given cases and extracts the parameter estimate for the specified path
#' (e.g., `var_one ~ var_two`).
#'
#' @param drops_index Integer vector of observation indices to drop from the data.
#' @param df A data frame containing the dataset.
#' @param model A lavaan SEM model specification.
#' @param var_one Character string giving the dependent (left-hand side) variable.
#' @param var_two Character string giving the predictor (right-hand side) variable.
#'
#' @return A numeric scalar giving the parameter estimate for the specified path
#' after removing the selected observations.
#'

#' @export
#Determine value of parameter for specific fit index
getValue <- function(drops_index,df, model,var_one, var_two) {
  df_drops <- df[-c(drops_index),]
  fit_drops = lavaan::sem(model, data=df_drops)
  new_estimates <- parameterEstimates(fit_drops)
  new_conc <- data.frame(c(new_estimates$lhs), c(new_estimates$rhs), val = c(new_estimates$est))
  new_int <- new_conc %>% filter_all(any_vars(. %in% c(var_one))) %>% filter_all(any_vars(. %in% c(var_two)))
  new_par_value = new_int$val
  return(new_par_value)
  # drops_index = sort(drops_index)
  #
  # return(.SEMClusterEnv$getValueWithMemory(drops_index,df, model,var_one, var_two))
}
