% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mcSetup.R
\name{summary.mcSetup}
\alias{summary.mcSetup}
\title{Summary Method for the S3 Class Object \code{mcSetup}}
\usage{
\method{summary}{mcSetup}(object, ...)
}
\arguments{
\item{object}{an object of the class \code{mcSetup} -- the output from the
\code{incrExplor()} function}

\item{...}{not used}
}
\value{
Returns a standard summary table (with basic description characteristics)
for raw run-off triangle increments and their standardized (by using the maximum
increment) counterparts. The function also returns the corresponding bins for
the increments and their representations in terms of the Markov chain states.
}
\description{
The function provides an overall summary of the output from the function
\code{incrExplor()}
}
\examples{
data(CameronMutual)
summary(CameronMutual)

## default summary output
summary(incrExplor(CameronMutual))

## summary output for user-modified settings
summary(incrExplor(CameronMutual, states = 5, method = "mean"))

}
\seealso{
\code{\link[=incrExplor]{incrExplor()}}, \code{\link[=mcBreaks]{mcBreaks()}}, \code{\link[=mcStates]{mcStates()}}
}
