% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play.R
\name{play}
\alias{play}
\alias{play.pt2mod}
\alias{play.pt2samp}
\alias{play.pt2patlist}
\alias{play.pt2pat}
\alias{play.pt2celllist}
\alias{play.pt2cell}
\title{Play a ProTrackR2 class objects as audio}
\usage{
\method{play}{pt2mod}(x, duration = NA, options = pt2_render_options(), position = 0L, ...)

\method{play}{pt2samp}(x, duration = 5, options = pt2_render_options(), note = "C-3", ...)

\method{play}{pt2patlist}(x, duration = NA, options = pt2_render_options(), samples, ...)

\method{play}{pt2pat}(x, duration = NA, options = pt2_render_options(), samples, ...)

\method{play}{pt2celllist}(x, duration = 5, options = pt2_render_options(), samples, ...)

\method{play}{pt2cell}(x, duration = 5, options = pt2_render_options(), samples, ...)
}
\arguments{
\item{x}{Object to be played.}

\item{duration}{Duration of the rendered output in seconds. When set to \code{NA}
the duration of the module is calculated and used for rendering.}

\item{options}{A list of options used for rendering the audio. Use
\code{\link[=pt2_render_options]{pt2_render_options()}} to obtain default options, or modify them.}

\item{position}{Starting position in the pattern sequence table (\code{pt2_pattern_table()}).
Should be a non negative value smaller than the mule length (\code{pt2_length()}).}

\item{...}{Arguments passed to \code{\link[=pt2_render]{pt2_render()}}.}

\item{note}{Note to be played when \code{x} is a \code{pt2samp} class object. Defaults
to \code{"C-3"}.}

\item{samples}{When rendering or playing patterns (or elements of it), samples are needed
to interpret the pattern. Pass the samples as a sample list (class \code{pt2samplist}).}
}
\value{
Returns an \verb{[audio::}$.audioInstance\verb{]} object which
allows you to control the playback (pause, resume, rewind).
}
\description{
Renders a ProTrackR2 class object as \code{\link[audio:audioSample]{audio::audioSample()}} and plays it.
}
\examples{
if (interactive()) {
  mod <- pt2_read_mod(pt2_demo())

  ## ctrl will contain the audioInstance that will let
  ## you control the audio playback:
  ctrl <- play(mod)

  ## You can also play individual samples
  samp <- mod$samples[[3]]
  play(samp, note = "C-2")
  play(samp, note = "E-2")
  play(samp, note = "G-2")
  
  ## As well as an individual pattern
  play(mod$patterns[[1]], samples = mod$samples)
  
  ## Or a subset of a pattern
  play(mod$patterns[[1]][17:32, 1:2], samples = mod$samples)
  
  ## Or even an individual cell
  play(mod$patterns[[1]][1, 1][[1]], samples = mod$samples)
}
}
\author{
Pepijn de Vries
}
