% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_top_n}
\alias{filter_top_n}
\title{Select Top N Stocks by Signal Value}
\usage{
filter_top_n(signal_df, n, ascending = FALSE)
}
\arguments{
\item{signal_df}{Data frame with Date column and signal values}

\item{n}{Number of stocks to select}

\item{ascending}{FALSE (default) selects highest, TRUE selects lowest}
}
\value{
Binary selection matrix (1 = selected, 0 = not selected)
}
\description{
Most commonly used filter function. Selects top N (highest) or bottom N (lowest)
stocks by signal value. Optimized for 5-10x faster performance.
}
\examples{
data("sample_prices_weekly")
momentum <- calc_momentum(sample_prices_weekly, 12)
# Select 10 highest momentum stocks
top_momentum <- filter_top_n(momentum, n = 10)
}
