% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_pin.R
\name{initials_pin_gwj}
\alias{initials_pin_gwj}
\title{Initial parameter set of Gan et al.(2015)}
\usage{
initials_pin_gwj(data, verbose = TRUE)
}
\arguments{
\item{data}{A dataframe with 2 variables: the first
corresponds to buyer-initiated trades (buys), and the second corresponds
to seller-initiated trades (sells).}

\item{verbose}{a binary variable that determines whether information messages
about the initial parameter sets, including the number of the initial
parameter sets generated. No message is shown when \code{verbose} is set
to \code{FALSE}. The default value is \code{TRUE}.}
}
\value{
Returns a dataframe containing numerical vector of five elements
\{\eqn{\alpha}, \eqn{\delta}, \eqn{\mu}, \eb, \es\}.
}
\description{
Based on the algorithm in
\insertCite{Gan2015;textual}{PINstimation}, generates an initial parameter
set for the maximum likelihood estimation of the \code{PIN} model.
}
\details{
The argument 'data' should be a numeric dataframe, and contain
at least two variables. Only the first two variables will be considered:
The first variable is assumed to correspond to the total number of
buyer-initiated trades, while the second variable is assumed to
correspond to the total number of seller-initiated trades. Each row or
observation correspond to a trading day. \code{NA} values will be ignored.
}
\examples{
# There is a preloaded quarterly dataset called 'dailytrades' with 60
# observations. Each observation corresponds to a day and contains the
# total number of buyer-initiated trades ('B') and seller-initiated
# trades ('S') on that day. To know more, type ?dailytrades

xdata <- dailytrades

# Obtain the initial parameter set for the maximum likelihood estimation
# using the algorithm of Gan et al.(2015).

initparams <- initials_pin_gwj(xdata)

# Use the obtained dataframe to estimate the PIN model using the function
# pin() with custom initial parameter sets

estimate.1 <- pin(xdata, initialsets = initparams, verbose = FALSE)

# pin_gwj() directly estimates the PIN model using an initial parameter set
# generated using the algorithm of Gan et al.(2015).

estimate.2 <- pin_gwj(xdata, "E", verbose = FALSE)

# Check that the obtained results are identical

show(estimate.1@parameters)
show(estimate.2@parameters)

}
\references{
\insertAllCited
}
