% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appStatic.R
\name{exportStaticApp}
\alias{exportStaticApp}
\title{Export and launch a static shiny specific to the provided results.}
\usage{
exportStaticApp(
  result,
  directory,
  logo = "ohdsi",
  title = "",
  background = TRUE,
  summary = TRUE,
  report = FALSE,
  panelDetails = panelDetailsFromResult(result),
  panelStructure = NULL,
  theme = NULL,
  template = NULL,
  updateButtons = TRUE,
  includeOneChoiceFilters = TRUE,
  open = rlang::is_interactive()
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{directory}{Directory to create the shiny.}

\item{logo}{Name of a logo or path to a logo. If NULL no logo is included.
Only svg format allowed for the moment.}

\item{title}{title of the shiny}

\item{background}{Whether to include a background panel. Background panel
content will be controlled from the generated background.md file.}

\item{summary}{Whether to include a panel with a summary of content in the
\code{result}.}

\item{report}{Whether to include a quarto report.}

\item{panelDetails}{A named list to provide details for each one of the
panels, such as: result_id, result_type, title, icon, filters and content.
By default it is created using the \code{panelDetailsFromResult()} function.}

\item{panelStructure}{A named list of panel identifiers to organise them in
drop-down menus. Identifiers names are the ones used in \code{panelDetails}. By
default one panel per each \code{panelDetails} element is created.}

\item{theme}{Specify the theme for the Shiny application. You can either
select a predefined theme provided by the package (e.g., \code{"theme1"}), or
define a custom theme using \code{bslib::bs_theme()}. If using a custom theme, it
must be provided as a character string (e.g.,
\code{"bslib::bs_theme(bg = 'white', fg = 'black')"}).}

\item{template}{Path to a template \code{.docx} document to be used for the
report.}

\item{updateButtons}{Whether to include update buttons for visualisations.}

\item{includeOneChoiceFilters}{Whether to include filter buttons for filters
with just one choice.}

\item{open}{Whether to open the shiny app project.}
}
\value{
The shiny app will be created in directory.
}
\description{
Export and launch a static shiny specific to the provided results.
}
\examples{
exportStaticApp(
  result = omopgenerics::emptySummarisedResult(),
  directory = tempdir()
)

}
