% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_main_effect}
\alias{plot_main_effect}
\title{Plot Main Effect}
\usage{
plot_main_effect(object, feature)
}
\arguments{
\item{object}{Either model of class \code{onam} as returned from \link{onam} or
model evaluation outcome as returned from \link{predict.onam}}

\item{feature}{Feature for which the effect is to be plotted, must be present
in the model formula. For interaction terms, use plotInteractionEffect}
}
\value{
Returns a ggplot2 object of the specified effect
}
\description{
Plot Main Effect
}
\examples{
\dontshow{if (reticulate::py_module_available(tensorflow)) withAutoprint(\{ # examplesIf}
# Basic example for a simple ONAM-model
# Create training data
n <- 1000
x1 <- runif(n, -2, 2)
x2 <- runif(n, -2, 2)
y <- sin(x1) + ifelse(x2 > 0, pweibull(x2, shape = 3),
  pweibull(-x2, shape = 0.5)) +
  x1 * x2
data_train <- cbind(x1, x2, y)
# Define model
model_formula <- y ~ mod1(x1) + mod1(x2) +
  mod1(x1, x2)
mod1 <- function(inputs) {
  outputs <- inputs \%>\%
    layer_dense(units = 16, activation = "relu") \%>\%
    layer_dense(units = 8, activation = "linear",
                use_bias = TRUE) \%>\%
    layer_dense(units = 1, activation = "linear",
                use_bias = TRUE)
  keras_model(inputs, outputs)
}
list_of_deep_models <- list(mod1 = mod1)
# Fit model
mod <- onam(model_formula, list_of_deep_models,
            data_train, n_ensemble = 1, epochs = 10)
plot_main_effect(mod, "x1")
\dontshow{\}) # examplesIf}
}
