% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_cascades.R
\name{simulate_cascades}
\alias{simulate_cascades}
\title{Simulate cascades from a diffusion network}
\usage{
simulate_cascades(diffnet, nsim = 1, max_time = Inf,
  start_probabilities = NULL, partial_cascade = NULL, params = NULL,
  model = NULL, nodes = NULL)
}
\arguments{
\item{diffnet}{object of class \code{diffnet}.}

\item{nsim}{integer, number of cascades to simulate.}

\item{max_time}{numeric, the maximum time after which observations are 
censored}

\item{start_probabilities}{a vector of probabilities for each node in diffnet,
to be the node with the first event. If \code{NULL} a node is drawn from
a uniform distribution over all nodes.}

\item{partial_cascade}{object of type cascade, containing one partial 
cascades for which further development should be simulated.}

\item{params}{numeric, (optional) parameters for diffusion time distribution. 
See the details section of \code{\link{netinf}} for specification details.
Only use this argument if parameters different from those contained in the 
\code{diffnet} object should be used or the network is not an object of 
class \code{diffnet}.}

\item{model}{character, diffusion model to use. One of \code{c("exponential", 
"rayleigh", "log-normal")}. Only use this argument if parameters different 
from those contained in the \code{diffnet} object should be used or the 
network is not an object of class \code{diffnet}.}

\item{nodes}{vector of node ids if different from nodes included in 
\code{diffnet}}
}
\value{
A data frame with three columns. Containing 1) The names of 
    the nodes (\code{"node_name"}) that experience an event in each cascade, 
    2) the event time (\code{"event_time"}) of the corresponding node, 
    3) the cascade identifier \code{"cascade_id"}.
}
\description{
Simulate diffusion cascades based on the generative model underlying netinf
and a diffusion network.
}
\examples{

data(cascades) 
out <- netinf(cascades, trans_mod = "exponential", n_edges = 5, params = 1)
simulated_cascades <- simulate_cascades(out, nsim = 10)
 
# Simulation from partial cascade

}
