% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPM_UPM_VaR.R
\name{UPM.VaR}
\alias{UPM.VaR}
\title{UPM VaR}
\usage{
UPM.VaR(percentile, degree, x)
}
\arguments{
\item{percentile}{numeric [0, 1]; The percentile for right-tail VaR (vectorized).}

\item{degree}{integer; \code{(degree = 0)} for discrete distributions, \code{(degree = 1)} for continuous distributions.}

\item{x}{a numeric vector.}
}
\value{
Returns a numeric value representing the point at which \code{"percentile"} of the area of \code{x} is above.
}
\description{
Generates an upside value at risk (VaR) quantile based on the Upper Partial Moment ratio
}
\examples{
set.seed(123)
x <- rnorm(100)

## For 5th percentile, right-tail
UPM.VaR(0.05, 0, x)
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments" (ISBN: 1490523995)
}
\author{
Fred Viole, OVVO Financial Systems
}
