% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inbreeding.emp.R
\name{inbreeding.emp}
\alias{inbreeding.emp}
\title{Empirical kinship}
\usage{
inbreeding.emp(
  population = NULL,
  animals = NULL,
  gen = NULL,
  database = NULL,
  cohorts = NULL,
  use.id = TRUE
)
}
\arguments{
\item{population}{Population list}

\item{animals}{List of animals to compute kinship for}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{database}{Groups of individuals to consider for the export}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{use.id}{Set TRUE to use animal IDs for column/row-names in the output matrix (default: TRUE)}
}
\value{
Empirical kinship matrix (IBD-based since Founders)
}
\description{
Function to compute empirical kinship for a set of individuals)
}
\examples{
data(ex_pop)
inbreeding <- inbreeding.emp(population=ex_pop, database=cbind(3,1,1,25))
}
