% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8.net_compare.R
\name{adjacency_similarity}
\alias{adjacency_similarity}
\title{Calculate Similarity Between Two Graphs via Adjacency Matrices}
\usage{
adjacency_similarity(g1, g2, method = "frobenius")
}
\arguments{
\item{g1}{An igraph object representing the first graph.}

\item{g2}{An igraph object representing the second graph.}

\item{method}{A character string specifying the similarity method:
"frobenius" (default) or "cosine".}
}
\value{
A numeric value between 0 (no similarity) and 1 (identical graphs).
}
\description{
Computes the similarity between two igraph objects using their adjacency matrices.
Supports Frobenius norm-based similarity and cosine similarity.
}
\examples{
library(igraph)
g1 <- graph_from_edgelist(matrix(c(1, 2, 2, 3), ncol = 2, byrow = TRUE), directed = FALSE)
g2 <- graph_from_edgelist(matrix(c(1, 2, 2, 4), ncol = 2, byrow = TRUE), directed = FALSE)
adjacency_similarity(g1, g2, method = "frobenius") # Output: 0.5
adjacency_similarity(g1, g2, method = "cosine") # Output: 0.5
}
