% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRStdCRT_fit.R
\name{MRStdCRT_fit}
\alias{MRStdCRT_fit}
\title{Model-robust Standardization Estimators for the Cluster Randomized Trials}
\usage{
MRStdCRT_fit(
  formula,
  data,
  cluster,
  trt,
  trtprob = rep(0.5, nrow(data)),
  method,
  family = gaussian(link = "identity"),
  corstr,
  scale,
  jack = 1,
  alpha = 0.05
)
}
\arguments{
\item{formula}{A formula for the outcome mean model, including covariates.}

\item{data}{A data frame where categorical variables should already be converted to dummy variables.}

\item{cluster}{A string representing the column name of the cluster ID in the data frame.}

\item{trt}{A string representing the column name of the treatment assignment per cluster (0=control, 1=treatment).}

\item{trtprob}{A vector of treatment probabilities per cluster (for each individual), conditional on covariates. Default is rep(0.5,nrow(data))}

\item{method}{A string specifying the outcome mean model. Possible values are:
- 'GLM': generalized linear model on cluster-level means (binary/continuous outcome).
- 'LMM': linear mixed model on individual-level observations (continuous outcome).
- 'GEE': marginal models fitted by generalized estimating equations.
- 'GLMM': generalized linear mixed model.}

\item{family}{The link function for the outcome. Can be one of the following:
- `gaussian(link = "identity")`: for continuous outcomes. Default is gaussian("identity").
- `binomial(link = "logit")`: for binary outcomes.
- `poisson(link = "log")`: for count outcomes.
- `gaussian(link = "logit")`: for binary outcomes with logit link to model the genealized linear model.}

\item{corstr}{A string specifying the correlation structure for GEE models (e.g., "exchangeable", "independence").}

\item{scale}{A string specifying the risk measure of interest. Can be 'RD' (risk difference), 'RR' (relative risk), or 'OR' (odds ratio).}

\item{jack}{A numeric value (1, 2, or 3) specifying the type of jackknife standard error estimate. Type 1 is the standard jackknife, and type 3 is recommended for small numbers of clusters. Default is 1.}

\item{alpha}{A numeric value for the type-I error rate. Default is 0.05.}
}
\value{
A list with the following components:
  - `estimate`: A summary table of estimates.
  - `m`: Number of clusters.
  - `N`: Total number of observations per cluster.
  - `family`: The family used for the model.
  - `model`: The method used for the outcome mean model.
}
\description{
This function performs cluster randomized trials (CRT) analysis using model-robust standardization estimators to estimate the cluster-average and individual-average treatment effect.
It handles different outcome mean models (GLM, LMM, GEE, GLMM) and supports both continuous, binary, and count outcomes with options for different correlation structures and scales (risk difference, risk ratio and odds ratio).
}
\examples{
\donttest{
utils::data("ppact", package = "MRStdCRT")

fit <- MRStdCRT_fit(
  formula = PEGS ~ AGE + FEMALE + comorbid + Dep_OR_Anx + pain_count + PEGS_bl +
    BL_benzo_flag + BL_avg_daily + satisfied_primary + n,
  data     = ppact,
  cluster  = "CLUST",
  trt      = "INTERVENTION",
  trtprob  = NULL,
  method   = "GEE",
  corstr   = "independence",
  scale    = "RR"
)
summary(fit)
}
}
