#' Assembly function: Exponential function
#'
#' This function evaluates the exponential function \deqn{f(x_1,x_2,\ldots,x_k)=\exp(\sum_{i=1}^kc_ix_{i}).}
#'
#' @param parameter The value of the parameters \eqn{x_1,x_2,\ldots,x_k}.
#' @param coefficient The value of the coefficients \eqn{c_1,c_2,\ldots,c_k}.
#'
#' @return
#' Value of the exponential function.
#'
#' @keywords internal
#' @noRd
Exponential<-function(parameter,coefficient)
{
  return(exp(sum(coefficient*parameter)))
}
