% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMMsolve-class.R
\name{summary.LMMsolve}
\alias{summary.LMMsolve}
\alias{print.summary.LMMsolve}
\title{Summarize Linear Mixed Model fits}
\usage{
\method{summary}{LMMsolve}(object, which = c("dimensions", "variances"), ...)

\method{print}{summary.LMMsolve}(x, ...)
}
\arguments{
\item{object}{An object of class LMMsolve}

\item{which}{A character string indicating which summary table should be
created.}

\item{\dots}{Some methods for this generic require additional arguments.
None are used in this method.}

\item{x}{An object of class summary.LMMsolve, the result of a call to
summary.LMM}
}
\value{
A data.frame with either effective dimensions or variances depending
on which.
}
\description{
Summary method for class "LMMsolve". Creates either a table of effective
dimensions (which = "dimensions") or a table of variances (which =
"variances").
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(summary.LMMsolve)}: print summary

}}
\examples{
## Fit model on oats data.
data(oats.data)

## Fit simple model with only fixed effects.
LMM1 <- LMMsolve(fixed = yield ~ rep + gen,
                data = oats.data)

## Obtain table of effective dimensions.
summ1 <- summary(LMM1)
print(summ1)

## Obtain table of variances.
summ2 <- summary(LMM1,
                which = "variances")
print(summ2)

}
