% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dengue_MS.R
\docType{data}
\name{dengue_MS}
\alias{dengue_MS}
\title{Dengue cases from the "Mato Grosso do Sul" state of Brazil}
\format{
A data frame with 2,600 rows and 27 columns:
\describe{
\item{\code{micro_code}}{Unique ID number to each
micro region (11 units)}
\item{\code{micro_name}}{Name of each micro region}
\item{\code{micro_name_ibge}}{Name of each micro region following IBGE}
\item{\code{meso_code}}{Unique ID number  to each
meso region (4 units)}
\item{\code{meso_name}}{Name of each meso region}
\item{\code{state_code}}{Unique ID number to each
state (1 unit)}
\item{\code{state_name}}{Name of each state}
\item{\code{region_code}}{Unique ID number given to each Brazilian Region,
In this data frame all observations come from the "Southeast Region"}
\item{\code{region_name}}{Name of each Brazilian Region,
In this data frame all observations come from the "Southeast Region"}
\item{\code{biome_code}}{Biome code}
\item{\code{biome_name}}{Biome name}
\item{\code{ecozone_code}}{Ecozone code}
\item{\code{ecozone_name}}{Ecozone name}
\item{\code{main_climate}}{Most prevalent climate regime in the microregion.
Based on Koppen Geiger climate regimes}
\item{\code{month}}{Calendar month index, 1 = January, 12 = December}
\item{\code{year}}{Year 2000 - 2019}
\item{\code{time}}{Time index starting at 1 for January 2000}
\item{\code{dengue_cases}}{Number of notified dengue cases registered in the
notifiable diseases system in Brazil (SINAN) in the microregion of
reference, at the month of first symptoms}
\item{\code{population}}{Estimated population, based on projections calculated
using the 2000 and 2010 censuses, and counts taken in 2007 and 2017}
\item{\code{pop_density}}{Population density (number of people per km2)}
\item{\code{tmax}}{Monthly average daily maximum temperature; gridded values
(at a 0.5 deg resolution) averaged across each microregion}
\item{\code{tmin}}{Monthly average daily minimum temperature; gridded values
(at a 0.5 deg resolution) averaged across each microregion}
\item{\code{pdsi}}{Self-calibrated Palmer drought severity index for each
microregion. It measures how wet or dry a region is relative to usual
conditions. Negative values represent periods of drought,
positive values represent wetter periods. Calculated by taking the mean
value within each microregion}
\item{\code{urban}}{Percentage of inhabitants living in urban areas (2010 census)}
\item{\code{water_network}}{Percentage of inhabitants with access to the piped
water network according to the 2010 census}
\item{\code{water_shortage}}{Frequency of reported water shortages per microregion
between 2000 - 2016}
\item{\code{date}}{First day of the Month, in date format ("\%d-\%m-\%Y")}
}
}
\source{
\href{https://github.com/drrachellowe/hydromet_dengue}{source code on GitHub};
\href{https://zenodo.org/records/4632205}{source code on Zenodo};
}
\usage{
dengue_MS
}
\description{
The \code{dengue_MS} example data set contains monthly counts of notified dengue cases by
microregion, along with a range of spatial and spatiotemporal covariates
(e.g., environmental, socio-economic and meteo-climatic factors).
This data set represents a subset of a larger national data set that covers
the entire territory of Brazil. The subset focuses on a specific region,
\emph{Mato Grosso do Sul}, for the purposes of illustration and computational efficiency.
See \code{@source} for access to the complete data set.
}
\keyword{datasets}
