% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CESAK_dc.R
\name{CESAK_dc}
\alias{CESAK_dc}
\title{Demand coefficients of the CESAK Production Function}
\usage{
CESAK_dc(alpha, betaK, alphaK, p, es = 1)
}
\arguments{
\item{alpha}{a positive scalar.}

\item{betaK}{a scalar between 0 and 1.}

\item{alphaK}{a nonnegative scalar.}

\item{p}{a 2-vector indicating the prices.}

\item{es}{a nonnegative scalar specifying the elasticity of substitution.}
}
\value{
A 2-vector indicating the demand coefficients.
}
\description{
Computing the demand coefficients of the CESAK production function
alpha * (betaK * x1^((es - 1) / es) + (1 - betaK) * x2^((es - 1) / es))^(es / (es - 1)) + alphaK * x1.
When es==1, the CESAK production function becomes the CDAK production function alpha * x1^betaK * x2^(1 - betaK) + alphaK * x1.
}
\examples{
\donttest{
CESAK_dc(alpha = 1, betaK = 0.35, alphaK = 1 - 0.06, p = c(10, 1))
CESAK_dc(alpha = 1, betaK = 0.35, alphaK = 1 - 0.06, p = c(1, 10))
CESAK_dc(alpha = 1, betaK = 0.35, alphaK = 2, p = c(1, 1))

CESAK_dc(alpha = 1, betaK = 0.35, alphaK = 1 - 0.06, p = c(1, 1), es = 0.5)
CESAK_dc(alpha = 1, betaK = 0.35, alphaK = 0.1, p = c(1, 10), es = 0.5)
CESAK_dc(alpha = 1, betaK = 0.35, alphaK = 1.5, p = c(1, 10), es = 0.5)
}

}
