% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMSD.R
\name{AMSD}
\alias{AMSD}
\alias{AMV}
\title{Additive-Mean-Variance Utility Function and Additive-Mean-Standard-Deviation Utility Function}
\usage{
AMSD(x, gamma = 1, wt = NULL, theta = 1)

AMV(x, gamma = 1, wt = NULL)
}
\arguments{
\item{x}{a numeric n-vector.}

\item{gamma}{a non-negative scalar representing the risk aversion coefficient with a default value of 1.}

\item{wt}{a numeric n-vector of weights (or probability).
If wt is NULL, all elements of x are given the same weight.}

\item{theta}{a non-negative scalar with a default value of 1.}
}
\value{
A scalar indicating the utility level.
}
\description{
Compute the utility function mean(x) - (gamma * sd.p(x))^theta / theta or
weighted.mean(x, wt) - (gamma * sd.p(x, wt))^theta / theta.
}
\section{Functions}{
\itemize{
\item \code{AMSD()}: Computes the utility function mean(x) - (gamma * sd.p(x))^theta / theta or
weighted.mean(x, wt) - (gamma * sd.p(x, wt))^theta / theta. When theta == 2, it is the additive mean-variance utility function (i.e.
the function AMV).
When theta == 1 (the default value), it is the additive mean and standard deviation utility function.

\item \code{AMV()}: Compute the additive mean-variance utility function mean(x) - 0.5 * gamma * var.p(x) or
weighted.mean(x, wt) - 0.5 * gamma * var.p(x, wt).

}}
\examples{
\donttest{
AMSD(1:2, gamma = 0.05)
AMSD(1:2, gamma = 1, theta = 2)

marginal_utility(
  c(1, 1.001),
  c(0, 1), function(x) AMSD(x, gamma = 0.5)
)
marginal_utility(
  c(1.001, 1),
  c(0, 1), function(x) AMSD(x, gamma = 0.5)
)
}

}
\references{
Nakamura, Yutaka (2015). Mean-Variance Utility. Journal of Economic Theory, 160: 536-556.
}
