% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{run_simulation}
\alias{run_simulation}
\title{Run one simulation in an FSK object}
\usage{
run_simulation(
  fsk_object,
  index,
  run_visualization = FALSE,
  copy_workspace = FALSE,
  workspace_mode = "all",
  inject_to_global = FALSE
)
}
\arguments{
\item{fsk_object}{Instance of FSK2R}

\item{index}{Index of the simulation}

\item{run_visualization}{Whether to call the visualization script. FALSE
by default.}

\item{copy_workspace}{Whether to copy the simulation workspace to the user's
working directory. FALSE by default.}

\item{workspace_mode}{What to copy when copy_workspace=TRUE. Options: "all" 
(copy everything), "generated" (copy only files created during simulation),
"modified" (copy only files modified during simulation). Default is "all".}

\item{inject_to_global}{Whether to inject simulation variables into the 
user's global environment for seamless model chaining. FALSE by default
for backward compatibility.}
}
\value{
A named list containing all variables created by the simulation model.
Each element preserves the original data type (numbers, strings, data frames,
lists, matrices, etc.). Returns an empty list if no variables are created.
When inject_to_global=TRUE, variables are also available in the global environment.
}
\description{
Runs the simulation corresponding to index. If defined, it also
calls any visualization script. Returns all user-created variables
from the simulation environment, supporting various data types including
scalars, vectors, data frames, lists, and matrices.
}
