% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfdb-annotation.R
\name{wfdb_annotation_labels}
\alias{wfdb_annotation_labels}
\alias{wfdb_annotation_decode}
\title{Standard WFDB annotation nomenclature}
\usage{
wfdb_annotation_labels(symbol = NULL, label_store = NULL)

wfdb_annotation_decode(annotation, column = "type")
}
\arguments{
\item{symbol}{Optional character vector of WFDB annotation symbols
to filter the results.}

\item{label_store}{Optional integer vector of WFDB label store
values to filter the results.}

\item{annotation}{An \code{\link[=annotation_table]{annotation_table()}} or compatible data frame
whose annotation symbols or label store values should be augmented
with the standard WFDB nomenclature.}

\item{column}{Name of the column within \code{annotation} that contains
either the WFDB symbol (default, for the \code{type} column) or the
label store values. If the column is numeric it is matched on
\code{label_store}, otherwise a symbol lookup is performed.}
}
\value{
\code{wfdb_annotation_labels()} returns a data frame with columns
\code{label_store}, \code{symbol}, \code{mnemonic}, and \code{description}.
\code{wfdb_annotation_decode()} returns the input annotation
table with the WFDB nomenclature columns appended.
}
\description{
Provides the standard label definitions used by WFDB
annotation files. These helper functions make it easier to
interpret the contents of the \code{\link[=annotation_table]{annotation_table()}} object by
exposing the symbol, mnemonic, and description that correspond to
each label store value defined in the WFDB Applications Guide
(Moody and collaborators).
}
\details{
The returned table is derived from the WFDB Application
Guide and matches the canonical label store values used by the
WFDB software distribution. Entries that are not currently defined
by the specification are omitted.
}
\examples{
wfdb_annotation_labels()

wfdb_annotation_labels(symbol = c("N", "V"))

ann <- annotation_table(
  annotator = "example",
  sample = c(100L, 200L),
  type = c("N", "V")
)

wfdb_annotation_decode(ann)

}
\references{
Moody GB. \emph{WFDB Applications Guide}. PhysioNet. Available at
\url{https://www.physionet.org/physiotools/wag/}.
}
