% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratifyByVocabulary.R
\name{stratifyByVocabulary}
\alias{stratifyByVocabulary}
\title{Subset a codelist to only those codes from a particular domain.}
\usage{
stratifyByVocabulary(
  x,
  cdm,
  nameStyle = "{codelist_name}_{vocabulary}",
  keepOriginal = FALSE
)
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{nameStyle}{Naming of the new codelists, use \code{{codelist_name}} to
include the codelist name and \code{{vocabulary}} to include the vocabulary name.}

\item{keepOriginal}{Whether to keep the original codelist (TRUE) or just return
the stratified ones (FALSE).}
}
\value{
The codelist with the required stratifications, as different elements
of the list.
}
\description{
Subset a codelist to only those codes from a particular domain.
}
\examples{
\donttest{
library(CodelistGenerator)

cdm <- mockVocabRef()

codes <- stratifyByVocabulary(
  x = newCodelist(list("codes" = c(10L, 13L, 15L))),
  cdm = cdm,
  keepOriginal = TRUE
)

codes
}

}
