% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getATCCodes.R
\name{getATCCodes}
\alias{getATCCodes}
\title{Get the descendant codes of Anatomical Therapeutic Chemical (ATC) classification codes}
\usage{
getATCCodes(
  cdm,
  level = c("ATC 1st"),
  name = NULL,
  nameStyle = "{concept_code}_{concept_name}",
  doseForm = NULL,
  doseUnit = NULL,
  routeCategory = NULL,
  type = "codelist"
)
}
\arguments{
\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{level}{ATC level. Can be one or more of "ATC 1st", "ATC 2nd",
"ATC 3rd", "ATC 4th", and "ATC 5th".}

\item{name}{ATC name of interest. For example, c("Dermatologicals",
"Nervous System"), would result in a list of length two with the descendant
concepts for these two particular ATC groups.}

\item{nameStyle}{Name style to apply to returned list. Can be one of
\code{"{concept_code}"},\code{"{concept_id}"}, \code{"{concept_name}"}, or a combination (i.e.,
\code{"{concept_code}_{concept_name}"}).}

\item{doseForm}{Only codes with the specified dose form
will be returned. If NULL, descendant codes will be returned regardless
of dose form. Use 'doseForms()' to see the available dose forms.}

\item{doseUnit}{Only codes with the specified dose unit
will be returned. If NULL, descendant codes will be returned regardless
of dose unit Use 'availableDoseUnits()' to see the available dose units.}

\item{routeCategory}{Only codes with the specified route will be
returned. If NULL, descendant codes will be returned regardless of route
category. Use getRoutes() to find the available route categories.}

\item{type}{Can be "codelist" or "codelist_with_details".}
}
\value{
Concepts with their format based on the type argument
}
\description{
Get the descendant codes of Anatomical Therapeutic Chemical (ATC) classification codes
}
\examples{
\donttest{
library(CodelistGenerator)
library(omock)

# Create CDM object
cdm <- mockCdmReference()

# Create a codelist with 1st level ATC codes available in the CDM
codelist <- getATCCodes(cdm = cdm,
                        level = "ATC 1st")
codelist

# Tune the name of the generated codelists
codelist <- getATCCodes(cdm = cdm,
                        level = "ATC 1st",
                        nameStyle = "{concept_name}_{concept_code}")
codelist

# Search for a specific ATC name of interest
codelist <- getATCCodes(cdm = cdm,
                        level = "ATC 2nd",
                        name = "immunostimulants")
codelist

# Restrict concepts to specific dose forms, dose units, or route categories.
# Remember that you can use `availableDoseForm()`, `availableDoseUnit()` and
# `availableRouteCategory()` to explore your codelist.
codelist <- getATCCodes(cdm = cdm,
                        level = "ATC 2nd",
                        doseForm = NULL,
                        doseUnit = NULL,
                        routeCategory = NULL,)
codelist

# You can also create directly a codelist_with_details using the argument `type`
codelist <- getATCCodes(cdm = cdm,
                        level = "ATC 1st",
                        type = "codelist_with_details")
codelist
}
}
