% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caesar.R
\name{cellembedding_seurat}
\alias{cellembedding_seurat}
\title{Perform CAESAR embedding of Cells Using FAST with Spatial Weights}
\usage{
cellembedding_seurat(
  seu,
  adjm,
  assay = NULL,
  slot = "data",
  nfeatures = 2000,
  q = 50,
  reduction.name = "caesar",
  var.features = NULL,
  ...
)
}
\arguments{
\item{seu}{A Seurat object. The Seurat object should contain gene expression data and be preprocessed with variable features identified.}

\item{adjm}{A spatial adjacency matrix representing the relationships between cells or spots in spatial transcriptomic data.}

\item{assay}{A character string specifying which assay to use from the Seurat object. If NULL, the function will use the default assay.}

\item{slot}{The data slot to use for feature extraction (e.g., "data", "counts"). Default is "data".}

\item{nfeatures}{The number of features to select for analysis. Default is 2000.}

\item{q}{An integer specifying the number of dimensions for the reduced embeddings. Default is 50.}

\item{reduction.name}{A character string specifying the name for the dimensional reduction. Default is "caesar".}

\item{var.features}{A vector of variable features (genes) to use for the embedding. If NULL, the function will use variable features stored in the Seurat object.}

\item{...}{Additional arguments passed to `FAST_run`.}
}
\value{
The modified Seurat object with the co-embedding results (cell and gene embeddings) stored in the specified dimensional reduction slot.
}
\description{
This function computes cell embedding using the CAESAR framework with FAST for dimensionality reduction and spatial adjacency weights. It integrates variable feature selection and spatial adjacency information to generate low-dimensional representations for cells.
}
\examples{
data(toydata)

seu <- toydata$seu
pos <- toydata$pos

adjm <- ProFAST::AddAdj(as.matrix(pos), radius.upper = 200)
seu <- cellembedding_seurat(
    seu = seu,
    adjm = adjm
)
print(seu)
}
\seealso{
\code{\link[ProFAST]{FAST_run}} for the main FAST dimensionality reduction algorithm.
}
