% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeReinforcedToxicity.R
\name{TRT.beeSurvFit}
\alias{TRT.beeSurvFit}
\title{Calculate the presence of Time Reinforced Toxicity for the compound from the
calibrated model \code{beeSurvFit} object.}
\usage{
\method{TRT}{beeSurvFit}(object, concRange = NULL)
}
\arguments{
\item{object}{An object of class \code{beeSurvFit}}

\item{concRange}{Argument of LCx, range of concentrations to find LDD50}
}
\value{
A object of class \code{ggplot} containing the graph of the comparison
between Haber's law and the predicted lethal doses at 10 and 27 days and a
data.frame with the plotted values.
}
\description{
Calculate the presence of Time Reinforced Toxicity for the compound from the
calibrated model \code{beeSurvFit} object.
}
\examples{
\donttest{
data(fitBetacyfluthrin_Chronic)
TRT(fitBetacyfluthrin_Chronic)
}
}
