% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_data.r
\name{count_data}
\alias{count_data}
\title{Count the number of observations}
\usage{
count_data(data, ..., na.rm = FALSE, pct = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{...}{One or more unquoted (categorical) column names from the data
frame, separated by commas.}

\item{na.rm}{A boolean specifying whether missing values (including NaN)
should be removed.}

\item{pct}{A boolean indicating whether to calculate percentages instead of
proportions. The default is \code{FALSE}.}
}
\description{
\code{\link[=count_data]{count_data()}} returns the number and proportion of observations for
categorical variables.
}
\details{
The data frame can be grouped using \code{\link[dplyr:group_by]{dplyr::group_by()}}
so that the number of observations will be calculated within each group
level.
}
\examples{
count_data(quote_source, source)
count_data(quote_source, source, sex)
count_data(quote_source, source, sex, na.rm = TRUE)
count_data(quote_source, source, sex, na.rm = TRUE, pct = TRUE)

# Use dplyr::group_by() to calculate proportions within a group
quote_source |>
  dplyr::group_by(source) |>
  count_data(sex)

}
