% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/das_class.R
\name{das_dfr-class}
\alias{das_dfr-class}
\alias{das_dfr}
\title{\code{das_dfr} class}
\description{
The \code{das_dfr} class is a subclass of \code{\link[base]{data.frame}},
  created to provide a concise and robust way to ensure that the input to \code{\link{das_process}}
  adheres to certain requirements.
  Specifically, objects of class \code{das_dfr} are data frames with specific column names and classes,
  as detailed in the 'Properties of \code{das_dfr}' section. Objects of class \code{das_dfr} are created by
  \code{\link{das_read}} or \code{\link{as_das_dfr}}, and are intended to be passed directly to
  \code{\link{das_process}}.

  Subsetting or otherwise altering an object of class \code{das_dfr} will cause the object to drop its
  \code{das_dfr} class attribute. \code{\link{das_process}} will then try to coerce the object to a
  \code{das_dfr} object. It is \bold{strongly} recommended to pass an object of class \code{das_dfr} to
  \code{\link{das_process}} before subsetting, e.g. for events from a certain date range.
}
\section{Properties of \code{das_dfr} objects}{


  Objects of class \code{das_dfr} have a class attribute of \code{c("das_dfr", "data.frame")}.
  In addition, they must have the following column names and classes:
  \tabular{ll}{
    \emph{Column name} \tab \emph{Column class}\cr
    Event     \tab "character"\cr
    EffortDot \tab "logical"\cr
    DateTime  \tab c("POSIXct", "POSIXt")\cr
    Lat       \tab "numeric"\cr
    Lon       \tab "numeric"\cr
    Data1 \tab "character"\cr
    Data2 \tab "character"\cr
    Data3 \tab "character"\cr
    Data4 \tab "character"\cr
    Data5 \tab "character"\cr
    Data6 \tab "character"\cr
    Data7 \tab "character"\cr
    Data8 \tab "character"\cr
    Data9 \tab "character"\cr
    Data10 \tab "character"\cr
    Data11 \tab "character"\cr
    Data12 \tab "character"\cr
    EventNum \tab "integer"\cr
    file_das \tab "character"\cr
    line_num \tab "integer"\cr
  }
}

\seealso{
\code{\link{as_das_dfr}}
}
