% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{cindex_survmat}
\alias{cindex_survmat}
\title{Concordance Index from a Survival Probability Matrix}
\usage{
cindex_survmat(object, predicted, t_star = NULL)
}
\arguments{
\item{object}{A `Surv` object representing the observed survival data.}

\item{predicted}{A data frame or matrix of predicted survival probabilities.
Each column corresponds to a time point (e.g., `t=90`, `t=180`).}

\item{t_star}{A numeric time point corresponding to one of the columns in `predicted`.
If `NULL`, the last column is used.}
}
\value{
A single numeric value representing the C-index.
}
\description{
Computes the time-dependent concordance index (C-index) from a predicted survival matrix
at a fixed time point. The risk is computed as `1 - S(t_star)`.
}
\examples{
library(survival)
data(veteran, package = "survival")
mod <- survdnn(Surv(time, status) ~
age + karno + celltype, data = veteran, epochs = 50, verbose = FALSE)
pred <- predict(mod, newdata = veteran, type = "survival", times = c(30, 90, 180))
y <- model.response(model.frame(mod$formula, veteran))
cindex_survmat(y, pred, t_star = 180)
}
