% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.rule.bin.R
\name{lines.rule.bin}
\alias{lines.rule.bin}
\title{Add Stopping Rule Curve to Current Plot (Binary Data)}
\usage{
\method{lines}{rule.bin}(x, smooth = TRUE, ...)
}
\arguments{
\item{x}{A \code{rule.bin} object calculated by \code{calc.rule.bin()} function}

\item{smooth}{Binary indicator of whether stopping rule boundary should be smoothed by linear interpolation between evaluation points}

\item{...}{Other options to be passed to generic \code{lines} function}
}
\value{
No return value; function solely modifies current plot
}
\description{
Add a binary stopping rule graphically as a curve on current plot
}
\examples{
\dontrun{# Binomial Pocock test in 50 patient cohort at 10\% level, expected toxicity probability of 20\%
poc_rule = calc.rule.bin(ns=1:50,p0=0.20,alpha=0.10,type="Pocock")

# Bayesian beta-binomial method of Geller et al. in 50 patient cohort at 10\% level,
# expected toxicity probability of 20\%
bb_rule = calc.rule.bin(ns=1:50,p0=0.20,alpha=0.10,type="BB",param=c(2,8))

# Plot stopping boundaries for stopping rules
plot(poc_rule,col="blue")
lines(bb_rule,col="red")
}
}
