require(stacomiR)

stacomi(
	database_expected=FALSE, sch='logrami')
# this requires a database with the schema logrami
# prompt for user and password but you can set appropriate options for host, port and dbname
\dontrun{
	stacomi(database_expected=TRUE, sch='logrami')	
	if (interactive()){
		if (!exists("user")){
			user <- readline(prompt="Enter user: ")
			password <- readline(prompt="Enter password: ")	
		}	
	}
	options(					
			stacomiR.dbname = "bd_contmig_nat",
			stacomiR.host ="localhost",
			stacomiR.port = "5432",
			stacomiR.user = user,
			stacomiR.user = password						
	)	
  r_mig_char <- new("report_mig_char")
  # here parqual is not in the list
  # so this is equivalent to parqual=NULL
  # default for echantillon is "with"
  r_mig_char <- choice_c(r_mig_char,
	  dc=c(107,108,101),
	  taxa=c("Salmo salar"),
	  stage=c('5','11','BEC','BER','IND'),
	  parquan=c('C001','1786','1785'),
	  horodatedebut="2012-01-01",
	  horodatefin="2012-12-31",
	  silent=FALSE)
  # r_mig_char<-charge(r_mig_char) not necessary there
  r_mig_char <- connect(r_mig_char)
  
}	
# load the dataset generated by previous lines
data("r_mig_char")

r_mig_char<-calcule(r_mig_char, silent=TRUE)
plot(r_mig_char,plot.type="quant", silent=TRUE)
# one quantitative parameter found, manual choice of color
plot(r_mig_char,plot.type="quant",color_parm=c("C001"="red"), silent=TRUE)
# age will be plotted as a qualitative variable
# here we split size data accoding to the limit known between different ages from
# scale reading in the Loire
r_mig_char <- setasqualitative(r_mig_char,par='C001',
		breaks=c(0,675,850,2000),
		labels=c("age 1","age 2","age 3"))
r_mig_char<-calcule(r_mig_char, silent=TRUE)
plot(r_mig_char, plot.type="qual", silent=TRUE)
plot(r_mig_char, plot.type="crossed")
plot(r_mig_char, plot.type="crossed",
    color_parm=c("age 1"="#379ec6","age 2"="#173957","age 3"="#b09953"))
xt<-xtable(r_mig_char)
# use method print.xtable to get the output


