% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_plan_plot.R
\name{plot.TrialDesignPlan}
\alias{plot.TrialDesignPlan}
\title{Trial Design Plan Plotting}
\usage{
\method{plot}{TrialDesignPlan}(
  x,
  y,
  ...,
  main = NA_character_,
  xlab = NA_character_,
  ylab = NA_character_,
  type = NA_integer_,
  palette = "Set1",
  theta = NA_real_,
  plotPointsEnabled = NA,
  legendPosition = NA_integer_,
  showSource = FALSE,
  grid = 1,
  plotSettings = NULL
)
}
\arguments{
\item{x}{The trial design plan, obtained from \cr
\code{\link[=getSampleSizeMeans]{getSampleSizeMeans()}}, \cr
\code{\link[=getSampleSizeRates]{getSampleSizeRates()}}, \cr
\code{\link[=getSampleSizeSurvival]{getSampleSizeSurvival()}}, \cr
\code{\link[=getSampleSizeCounts]{getSampleSizeCounts()}}, \cr
\code{\link[=getPowerMeans]{getPowerMeans()}}, \cr
\code{\link[=getPowerRates]{getPowerRates()}} or \cr
\code{\link[=getPowerSurvival]{getPowerSurvival()}} or \cr
\code{\link[=getPowerCounts]{getPowerCounts()}}.}

\item{y}{Not available for this kind of plot (is only defined to be compatible to the generic plot function).}

\item{...}{Optional plot arguments. At the moment \code{xlim} and \code{ylim} are implemented
for changing x or y axis limits without dropping data observations.}

\item{main}{The main title.}

\item{xlab}{The x-axis label.}

\item{ylab}{The y-axis label.}

\item{type}{The plot type (default = \code{1}). The following plot types are available:
\itemize{
\item \code{1}: creates a 'Boundaries' plot
\item \code{2}: creates a 'Boundaries Effect Scale' plot
\item \code{3}: creates a 'Boundaries p Values Scale' plot
\item \code{4}: creates a 'Error Spending' plot
\item \code{5}: creates a 'Sample Size' or 'Overall Power and Early Stopping' plot
\item \code{6}: creates a 'Number of Events' or 'Sample Size' plot
\item \code{7}: creates an 'Overall Power' plot
\item \code{8}: creates an 'Overall Early Stopping' plot
\item \code{9}: creates an 'Expected Number of Events' or 'Expected Sample Size' plot
\item \code{10}: creates a 'Study Duration' plot
\item \code{11}: creates an 'Expected Number of Subjects' plot
\item \code{12}: creates an 'Analysis Times' plot
\item \code{13}: creates a 'Cumulative Distribution Function' plot
\item \code{14}: creates a 'Survival Function' plot
\item \code{"all"}: creates all available plots and returns it as a grid plot or list
}}

\item{palette}{The palette, default is \code{"Set1"}.}

\item{theta}{A vector of standardized effect sizes (theta values), default is a sequence from -1 to 1.}

\item{plotPointsEnabled}{Logical. If \code{TRUE}, additional points will be plotted.}

\item{legendPosition}{The position of the legend.
By default (\code{NA_integer_}) the algorithm tries to find a suitable position.
Choose one of the following values to specify the position manually:
\itemize{
\item \code{-1}: no legend will be shown
\item \code{NA}: the algorithm tries to find a suitable position
\item \code{0}: legend position outside plot
\item \code{1}: legend position left top
\item \code{2}: legend position left center
\item \code{3}: legend position left bottom
\item \code{4}: legend position right top
\item \code{5}: legend position right center
\item \code{6}: legend position right bottom
}}

\item{showSource}{Logical. If \code{TRUE}, the parameter names of the object will
be printed which were used to create the plot; that may be, e.g.,
useful to check the values or to create own plots with the base R \code{plot} function.
Alternatively \code{showSource} can be defined as one of the following character values:
\itemize{
\item \code{"commands"}: returns a character vector with plot commands
\item \code{"axes"}: returns a list with the axes definitions
\item \code{"test"}: all plot commands will be validated with \code{eval(parse())} and
returned as character vector (function does not stop if an error occurs)
\item \code{"validate"}: all plot commands will be validated with \code{eval(parse())} and
returned as character vector (function stops if an error occurs)
}
Note: no plot object will be returned if \code{showSource} is a character.}

\item{grid}{An integer value specifying the output of multiple plots.
By default (\code{1}) a list of \code{ggplot} objects will be returned.
If a \code{grid} value > 1 was specified, a grid plot will be returned
if the number of plots is <= specified \code{grid} value;
a list of \code{ggplot} objects will be returned otherwise.
If \code{grid = 0} is specified, all plots will be created using \code{\link[base]{print}} command
and a list of \code{ggplot} objects will be returned invisible.
Note that one of the following packages must be installed to create a grid plot:
'ggpubr', 'gridExtra', or 'cowplot'.}

\item{plotSettings}{An object of class \code{PlotSettings} created by \code{\link[=getPlotSettings]{getPlotSettings()}}.}
}
\value{
Returns a \code{ggplot2} object.
}
\description{
Plots a trial design plan.
}
\details{
Generic function to plot all kinds of trial design plans.
}
\examples{
\dontrun{
if (require(ggplot2)) plot(getSampleSizeMeans())
}

}
