% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_plan_means.R
\name{getPowerMeans}
\alias{getPowerMeans}
\title{Get Power Means}
\usage{
getPowerMeans(
  design = NULL,
  ...,
  groups = 2L,
  normalApproximation = FALSE,
  meanRatio = FALSE,
  thetaH0 = ifelse(meanRatio, 1, 0),
  alternative = seq(0, 1, 0.2),
  stDev = 1,
  directionUpper = NA,
  maxNumberOfSubjects = NA_real_,
  allocationRatioPlanned = NA_real_
)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used.
In this case, Type I error rate \code{alpha}, Type II error rate \code{beta}, \code{twoSidedPower},
and \code{sided} can be directly entered as argument where necessary.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and
that a warning will be displayed if unknown arguments are passed.}

\item{groups}{The number of treatment groups (1 or 2), default is \code{2}.}

\item{normalApproximation}{The type of computation of the p-values. If \code{TRUE}, the variance is
assumed to be known, default is \code{FALSE}, i.e., the calculations are performed
with the t distribution.}

\item{meanRatio}{If \code{TRUE}, the sample size for
one-sided testing of H0: \code{mu1 / mu2 = thetaH0} is calculated, default is \code{FALSE}.}

\item{thetaH0}{The null hypothesis value,
default is \code{0} for the normal and the binary case (testing means and rates, respectively),
it is \code{1} for the survival case (testing the hazard ratio).\cr\cr
For non-inferiority designs, \code{thetaH0} is the non-inferiority bound.
That is, in case of (one-sided) testing of
\itemize{
\item \emph{means}: a value \code{!= 0}
(or a value \code{!= 1} for testing the mean ratio) can be specified.
\item \emph{rates}: a value \code{!= 0}
(or a value \code{!= 1} for testing the risk ratio \code{pi1 / pi2}) can be specified.
\item \emph{survival data}: a bound for testing H0: \code{hazard ratio = thetaH0 != 1} can be specified.
\item \emph{count data}: a bound for testing H0: \code{lambda1 / lambda2 = thetaH0 != 1} can be specified.
}
For testing a rate in one sample, a value \code{thetaH0} in (0, 1) has to be specified for
defining the null hypothesis H0: \code{pi = thetaH0}.}

\item{alternative}{The alternative hypothesis value for testing means. This can be a vector of assumed
alternatives, default is \code{seq(0, 1, 0.2)} (power calculations) or \code{seq(0.2, 1, 0.2)} (sample size calculations).}

\item{stDev}{The standard deviation under which the sample size or power
calculation is performed, default is \code{1}.
For two-armed trials, it is allowed to specify the standard deviations separately,
i.e., as vector with two elements.
If \code{meanRatio = TRUE} is specified, \code{stDev} defines
the coefficient of variation \code{sigma / mu2}.}

\item{directionUpper}{Logical. Specifies the direction of the alternative,
only applicable for one-sided testing; default is \code{TRUE}
which means that larger values of the test statistics yield smaller p-values.}

\item{maxNumberOfSubjects}{\code{maxNumberOfSubjects > 0} needs to be specified for power calculations or calculation
of necessary follow-up (count data). For two treatment arms, it is the maximum number of subjects for both treatment arms.}

\item{allocationRatioPlanned}{The planned allocation ratio \code{n1 / n2} for a two treatment groups
design, default is \code{1}. For multi-arm designs, it is the allocation ratio relating the active arm(s) to the control.
For simulating means and rates for a two treatment groups design, it can be a vector of length \code{kMax}, the number of stages.
It can be a vector of length \code{kMax}, too, for multi-arm and enrichment designs.
In these cases, a change of allocating subjects to treatment groups over the stages can be assessed.
Note that internally \code{allocationRatioPlanned} is treated as a vector of length \code{kMax}, not a scalar.}
}
\value{
Returns a \code{\link{TrialDesignPlan}} object.
The following generics (R generic functions) are available for this result object:
\itemize{
\item \code{\link[=names.FieldSet]{names()}} to obtain the field names,
\item \code{\link[=print.FieldSet]{print()}} to print the object,
\item \code{\link[=summary.TrialDesignSet]{summary()}} to display a summary of the object,
\item \code{\link[=plot.TrialDesignPlan]{plot()}} to plot the object,
\item \code{\link[=as.data.frame.TrialDesignPlan]{as.data.frame()}} to coerce the object to a \code{\link[base]{data.frame}},
\item \code{\link[=as.matrix.FieldSet]{as.matrix()}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Returns the power, stopping probabilities, and expected sample size for
testing means in one or two samples at given maximum sample size.
}
\details{
At given design the function calculates the power, stopping probabilities,
and expected sample size for testing means at given sample size.
In a two treatment groups design, additionally, an allocation ratio = \code{n1 / n2}
can be specified where \code{n1} and \code{n2} are the number
of subjects in the two treatment groups.
A null hypothesis value thetaH0 != 0 for testing the difference of two means
or \code{thetaH0 != 1} for testing the ratio of two means can be specified.
For the specified sample size, critical bounds and stopping for futility
bounds are provided at the effect scale (mean, mean difference, or
mean ratio, respectively)
}
\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of
the \code{rpact} specific implementation of the generic.
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and
to identify the object specific name of it, e.g.,
use \code{methods("plot")} to get all the methods for the \code{plot} generic.
There you can find, e.g., \code{plot.AnalysisResults} and
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
\dontrun{
# Calculate the power, stopping probabilities, and expected sample size 
# for testing H0: mu1 - mu2 = 0 in a two-armed design against a range of 
# alternatives H1: mu1 - m2 = delta, delta = (0, 1, 2, 3, 4, 5), 
# standard deviation sigma = 8, maximum sample size N = 80 (both treatment 
# arms), and an allocation ratio n1/n2 = 2. The design is a three stage 
# O'Brien & Fleming design with non-binding futility bounds (-0.5, 0.5) 
# for the two interims. The computation takes into account that the t test 
# is used (normalApproximation = FALSE). 
getPowerMeans(getDesignGroupSequential(alpha = 0.025, 
    sided = 1, futilityBounds = c(-0.5, 0.5)), 
    groups = 2, alternative = c(0:5), stDev = 8,
    normalApproximation = FALSE, maxNumberOfSubjects = 80, 
    allocationRatioPlanned = 2)
}

}
\seealso{
Other power functions: 
\code{\link{getPowerCounts}()},
\code{\link{getPowerRates}()},
\code{\link{getPowerSurvival}()}
}
\concept{power functions}
