% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_analysis_results.R
\name{ConditionalPowerResultsEnrichmentRates}
\alias{ConditionalPowerResultsEnrichmentRates}
\title{Conditional Power Results Enrichment Rates}
\description{
Class for conditional power calculations of enrichment rates data
}
\details{
This object cannot be created directly; use \code{\link{getConditionalPower}}
with suitable arguments to create the results of a group sequential or a combination test design.
}
\section{Fields}{

\describe{
\item{\code{nPlanned}}{The sample size planned for each of the subsequent stages. Is a numeric vector of length \code{kMax} containing whole numbers.}

\item{\code{allocationRatioPlanned}}{The planned allocation ratio (\code{n1 / n2}) for the groups. For multi-arm designs, it is the allocation ratio relating the active arm(s) to the control. Is a positive numeric vector of length 1.}

\item{\code{iterations}}{The number of iterations used for simulations. Is a numeric vector of length 1 containing a whole number.}

\item{\code{seed}}{The seed used for random number generation. Is a numeric vector of length 1.}

\item{\code{simulated}}{Describes if the power for Fisher's combination test has been simulated. Only applicable when using Fisher designs. Is a logical vector of length 1.}

\item{\code{conditionalPower}}{The conditional power at each stage of the trial. Is a numeric vector of length 1 containing a value between 0 and 1.}

\item{\code{piTreatments}}{The assumed rates in the treatment groups for multi-arm and enrichment designs, i.e., designs with multiple subsets.}

\item{\code{piControls}}{The assumed rates in the control group for enrichment designs, i.e., designs with multiple subsets.}
}}

\keyword{internal}
