% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_api.R
\name{route_merge}
\alias{route_merge}
\title{Merge one route into another}
\usage{
route_merge(x, route, use_root = TRUE)
}
\arguments{
\item{x, route}{\link{Route} objects to merge. \code{route} will be merged into \code{x}}

\item{use_root}{Should the root of \code{route} be added to all its paths before
it is merged into \code{x}}
}
\value{
\code{x} with \code{route} merged into it
}
\description{
This function allows you to combine two separate routes into one. This is
different from combining them in a routestack, because a request is only
matched to one handler in each route (thus combining them with
\code{route_merge()} will ensure only one handler is called).
}
\examples{
\dontshow{if (packageVersion("base") >= "4.1.0") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
route() |>
  route_add("HEAD", "*", function(...) {
    message("Someone's looking")
    TRUE
  }) |>
  route_merge(
    sizelimit_route()
  )
\dontshow{\}) # examplesIf}
}
