% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMCMC.R
\name{readMCMC_Mk}
\alias{readMCMC_Mk}
\title{Read output files of MCMC for the predictor regimes.}
\usage{
readMCMC_Mk(
  handle,
  burn = 0,
  thin = 1,
  dir = NULL,
  return_Simmap = FALSE,
  nsims = 10,
  max_nshifts = 10000
)
}
\arguments{
\item{handle}{the output of the 'ratematrixJointMCMC' function.}

\item{burn}{the proportion of the burnin to be pruned from the MCMC chain. A number between 0 and 1 (default is 0).}

\item{thin}{the thinning of the posterior distribution. A number with the interval between each MCMC step to be kept in the posterior distribution (default is 1).}

\item{dir}{directory with the output files. If 'NULL' (default), then files are read from the directory chosen when running the MCMC chain using the argument 'dir' of the 'ratematrixJointMCMC' function (stored on handle). Otherwise function will read files from 'dir'.}

\item{return_Simmap}{if the output should be stochastic mapping simulations conditioned on a sample of Q matrices from the posterior distribution (TRUE) or a list of sampled Q matrices.}

\item{nsims}{number of stochastic mapping simulations to be done. These are based on the last 'nsims' sampled by the MCMC.}

\item{max_nshifts}{the maximum number of state transitions in any branch of the phylogeny when making stochastic mapping simulations. If you get errors in the stochastic mapping step, try increasing this value. However, this indicates a VERY fast transition rate. See 'fastSimmap' function for more information.}
}
\value{
List with the MCMC chain for the transition matrices or a list of stochastic mappings. See parameter 'return_Simmap'.
}
\description{
Read the results of the MCMC chain for the predictor regimes.
}
\details{
Function will use 'readr' package to read the output files produced by the Markov chain Monte Carlo
   analysis focused on the transition rates between the predictor states (the Mk model) made as part
   of the 'ratematrixJointMCMC' analysis.
}
\author{
Daniel S. Caetano and Luke J. Harmon
}
